/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.energy;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.antarcticgardens.esl.ESL;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEnergyStorageManager {
    private final Map<class_2591<? extends class_2586>, BiFunction<class_2586, class_2350, EnergyStorage>> blockEntityProviders = new HashMap<class_2591<? extends class_2586>, BiFunction<class_2586, class_2350, EnergyStorage>>();

    public <T extends class_2586> void registerForBlockEntity(BiFunction<T, class_2350, EnergyStorage> provider, class_2591<T> blockEntityType) {
        if (this.blockEntityProviders.containsKey(blockEntityType)) {
            ESL.LOGGER.trace("Duplicate energy storage registration for " + blockEntityType);
            return;
        }
        this.blockEntityProviders.put(blockEntityType, provider);
        this.platformRegisterForBlockEntity(provider, blockEntityType);
    }

    public boolean isBlockEntityRegisteredInESL(class_2591<?> blockEntityType) {
        return this.blockEntityProviders.containsKey(blockEntityType);
    }

    public EnergyStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        EnergyStorage storage;
        BiFunction<class_2586, class_2350, EnergyStorage> provider;
        class_2586 be = world.method_8321(pos);
        if (be != null && (provider = this.blockEntityProviders.get(be.method_11017())) != null && (storage = provider.apply(be, direction)) != null) {
            return storage;
        }
        return this.platformFind(world, pos, direction);
    }

    protected abstract <T extends class_2586> void platformRegisterForBlockEntity(BiFunction<T, class_2350, EnergyStorage> var1, class_2591<T> var2);

    protected abstract EnergyStorage platformFind(class_1937 var1, class_2338 var2, @Nullable class_2350 var3);
}

